---@meta

---@class ULensComponent : UActorComponent
---@field LensFilePicker FLensFilePicker
---@field EvaluationMode EFIZEvaluationMode
---@field TargetCameraComponent FComponentReference
---@field EvalInputs FLensFileEvaluationInputs
---@field DistortionStateSource EDistortionSource
---@field bApplyDistortion boolean
---@field LensModel TSubclassOf<ULensModel>
---@field DistortionState FLensDistortionState
---@field bScaleOverscan boolean
---@field OverscanMultiplier float
---@field FilmbackOverride EFilmbackOverrideSource
---@field CroppedFilmback FCameraFilmbackSettings
---@field bApplyNodalOffsetOnTick boolean
---@field OriginalTrackedComponentTransform FTransform
---@field bIsDistortionSetup boolean
---@field OriginalFocalLength float
---@field LastDistortionMID UMaterialInstanceDynamic
---@field LastCameraComponent UCineCameraComponent
---@field LensDistortionHandlerMap TMap<TSubclassOf<ULensModel>, ULensDistortionModelHandlerBase>
---@field TrackedComponent TWeakObjectPtr<USceneComponent>
---@field TrackedComponentName FString
local ULensComponent = {}

---@return boolean
function ULensComponent:WasNodalOffsetAppliedThisTick() end
---@return boolean
function ULensComponent:WasDistortionEvaluated() end
---@return boolean
function ULensComponent:ShouldApplyNodalOffsetOnTick() end
---@return boolean
function ULensComponent:ShouldApplyDistortion() end
---@param Multiplier float
function ULensComponent:SetOverscanMultiplier(Multiplier) end
---@param Model TSubclassOf<ULensModel>
function ULensComponent:SetLensModel(Model) end
---@param LensFile FLensFilePicker
function ULensComponent:SetLensFilePicker(LensFile) end
---@param LensFile ULensFile
function ULensComponent:SetLensFile(LensFile) end
---@param Mode EFIZEvaluationMode
function ULensComponent:SetFIZEvaluationMode(Mode) end
---@param Setting EFilmbackOverrideSource
function ULensComponent:SetFilmbackOverrideSetting(Setting) end
---@param State FLensDistortionState
function ULensComponent:SetDistortionState(State) end
---@param Source EDistortionSource
function ULensComponent:SetDistortionSource(Source) end
---@param Filmback FCameraFilmbackSettings
function ULensComponent:SetCroppedFilmback(Filmback) end
---@param bApplyNodalOffset boolean
function ULensComponent:SetApplyNodalOffsetOnTick(bApplyNodalOffset) end
---@param bApply boolean
function ULensComponent:SetApplyDistortion(bApply) end
---@return float
function ULensComponent:GetOverscanMultiplier() end
---@return float
function ULensComponent:GetOriginalFocalLength() end
---@return TSubclassOf<ULensModel>
function ULensComponent:GetLensModel() end
---@return FLensFilePicker
function ULensComponent:GetLensFilePicker() end
---@return FLensFileEvaluationInputs
function ULensComponent:GetLensFileEvaluationInputs() end
---@return ULensFile
function ULensComponent:GetLensFile() end
---@return ULensDistortionModelHandlerBase
function ULensComponent:GetLensDistortionHandler() end
---@return EFIZEvaluationMode
function ULensComponent:GetFIZEvaluationMode() end
---@return EFilmbackOverrideSource
function ULensComponent:GetFilmbackOverrideSetting() end
---@return FLensDistortionState
function ULensComponent:GetDistortionState() end
---@return EDistortionSource
function ULensComponent:GetDistortionSource() end
---@return FCameraFilmbackSettings
function ULensComponent:GetCroppedFilmback() end
function ULensComponent:ClearDistortionState() end
---@param ComponentToOffset USceneComponent
---@param bUseManualInputs boolean
---@param ManualFocusInput float
---@param ManualZoomInput float
function ULensComponent:ApplyNodalOffset(ComponentToOffset, bUseManualInputs, ManualFocusInput, ManualZoomInput) end


